/**
* Script: radialstate.js
* Written by: Radnen
* Updated: 10/28/2010
**/

function RadialMenuState(name, radius)
{
	if (!name) name = "RadialMenuState";
	if (!radius) radius = 20;
	
	this.inherit = GUIState;
	this.inherit(name, 0, 0, SW, SH);
	
	var panel = this.createBasePanel();
	panel.useWindow = false;
	panel.backColor = Colors.clearBlack;
	
	var radialmenu = new RadialMenu(panel, radius);
	radialmenu.backImage = Resources.images.radial;
	radialmenu.onHide.add(function(sender) {
		sender.hide();
	}, this);
	
	panel.controls.push(radialmenu);
	
	// overridden show function, changes position of menu:
	this.show = function(x, y) {
		radialmenu.show(x, y);
		StateManager.push(this);
	}
	
	// wrapper for private radial menu class:
	this.addItem = function(name, image, callback) {
		radialmenu.addItem(name, image, callback);
	}
	
	this.doInput = function(key) {
		switch(key) {
			case KEY_ESCAPE: this.hide(); break;
		}
	}
}